require( "scripts/style.lua" );


MovieTitleFont = {
  standardFont,
  40,
  BorderColor
};


function MakeMovieButton(xloc, yloc, icon, movie  )
	return Group(
		{
			SetStyle(StandardButtonStyle);
			Button
			{
				x = xloc,
				y = yloc,
				graphics={icon, icon, icon};
				command=
					function()
						SetDefaultStyle(ComicStyle);
						ActivateMovieClock(true);
						DisplaySplash(movie, "",1);
						ActivateMovieClock(false);
						SetDefaultStyle(DefaultStyle);
					end	
			};
		}
	);
end


MakeDialog
{
	
	Bitmap
	{
		name="backgroundimage",
		image="backgrounds/fullscreendialog",
		x=0,
		y=0,
		fit = false,
		
		Text
		{
			x = 0,
			y = 100,
			w = kMax,
			h = 100,
			flags = kHAlignCenter + kVAlignTop,
			font = MovieTitleFont,
			label = 'movies'
		};
		
		MakeMovieButton(100, 300, "downloads/_default/restaurants/zoo/icon/icon.png", "downloads/_default/restaurants/zoo/comics/intro.swf");
		MakeMovieButton(100, 400, "downloads/_default/restaurants/ballpark/icon/icon.png", "downloads/_default/restaurants/ballpark/comics/intro.swf");
		MakeMovieButton(100, 500, "downloads/_default/restaurants/museum/icon/icon.png", "downloads/_default/restaurants/museum/comics/intro.swf");
		MakeMovieButton(400, 300, "downloads/_default/restaurants/boardwalk/icon/icon.png", "downloads/_default/restaurants/boardwalk/comics/intro.swf");
		MakeMovieButton(400, 400, "downloads/_default/restaurants/disco/icon/icon.png", "downloads/_default/restaurants/disco/comics/intro.swf");
		MakeMovieButton(400, 500, "downloads/_default/restaurants/disco/icon/icon.png", "downloads/_default/restaurants/disco/comics/outro.swf");
		SetStyle(StandardButtonStyle);
		
		Button
		{
			x=575,
			y=500,
			label='back',
			command=
				function()
					PopModal("scripts/movies.lua");
				end
		},
		
			
	},
	
}
